/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card.config;

import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ISubMenuHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.SlotSemantic;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.FakeSlot;
import appeng.util.ConfigInventory;
import appeng.util.ConfigMenuInventory;
import de.mari_023.ae2wtlib.AE2wtlibSlotSemantics;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.WCTMenuHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class MagnetMenu
extends AEBaseMenu
implements ISubMenu {
    public static final MenuType<MagnetMenu> TYPE = MenuTypeBuilder.create(MagnetMenu::new, WCTMenuHost.class).build("magnet");
    private final WCTMenuHost host;
    private final MagnetHost magnetHost;
    private static final String TOGGLE_PICKUP_MODE = "togglepickupmode";
    private static final String TOGGLE_INSERT_MODE = "toggleinsertmode";
    private static final String COPY_UP = "copy_up";
    private static final String COPY_DOWN = "copy_down";
    private static final String SWITCH_INSERT_PICKUP = "switch";

    public MagnetMenu(int id, Inventory playerInventory, WCTMenuHost host) {
        super(TYPE, id, playerInventory, (Object)host);
        this.host = host;
        this.magnetHost = CraftingTerminalHandler.getCraftingTerminalHandler(playerInventory.f_35978_).getMagnetHost();
        if (this.magnetHost == null) {
            return;
        }
        this.addConfigSlots(this.magnetHost.pickupConfig, AE2wtlibSlotSemantics.PICKUP_CONFIG);
        this.addConfigSlots(this.magnetHost.insertConfig, AE2wtlibSlotSemantics.INSERT_CONFIG);
        this.createPlayerInventorySlots(playerInventory);
        this.registerClientAction(TOGGLE_PICKUP_MODE, this::togglePickupMode);
        this.registerClientAction(TOGGLE_INSERT_MODE, this::toggleInsertMode);
        this.registerClientAction(COPY_UP, this::copyUp);
        this.registerClientAction(COPY_DOWN, this::copyDown);
        this.registerClientAction(SWITCH_INSERT_PICKUP, this::switchInsertPickup);
    }

    private void addConfigSlots(ConfigInventory config, SlotSemantic slotSemantic) {
        ConfigMenuInventory inv = config.createMenuWrapper();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot((Slot)new FakeSlot((InternalInventory)inv, y * 9 + x), slotSemantic);
            }
        }
    }

    public ISubMenuHost getHost() {
        return this.host;
    }

    public MagnetHost getMagnetHost() {
        return this.magnetHost;
    }

    public void togglePickupMode() {
        if (this.isClientSide()) {
            this.sendClientAction(TOGGLE_PICKUP_MODE);
            if (Minecraft.m_91087_().m_91090_()) {
                return;
            }
        }
        this.magnetHost.togglePickupMode();
    }

    public void toggleInsertMode() {
        if (this.isClientSide()) {
            this.sendClientAction(TOGGLE_INSERT_MODE);
            if (Minecraft.m_91087_().m_91090_()) {
                return;
            }
        }
        this.magnetHost.toggleInsertMode();
    }

    public void copyUp() {
        if (this.isClientSide()) {
            this.sendClientAction(COPY_UP);
            if (Minecraft.m_91087_().m_91090_()) {
                return;
            }
        }
        this.magnetHost.copyUp();
    }

    public void copyDown() {
        if (this.isClientSide()) {
            this.sendClientAction(COPY_DOWN);
            if (Minecraft.m_91087_().m_91090_()) {
                return;
            }
        }
        this.magnetHost.copyDown();
    }

    public void switchInsertPickup() {
        if (this.isClientSide()) {
            this.sendClientAction(SWITCH_INSERT_PICKUP);
            if (Minecraft.m_91087_().m_91090_()) {
                return;
            }
        }
        this.magnetHost.switchInsertPickup();
    }
}

